package model;

import java.util.Observable;

public class ProxyExecution extends Observable implements IExecution {

	private IExecution execution;
	
	public ProxyExecution(IExecution execution) {
		this.execution = execution;
		
	}
	
	public void setParameter(int N){
		this.execution.setParameter(N);
		
	}
	
	public void setActives(int index, boolean isactive){
		this.execution.setActives(index, isactive);
		
	}
	
	public boolean[] getActives(){
		return execution.getActives();
	}
	
	public void run(){
		this.execution.run();
		up();
	}
	
	public String[] getTimes(){
		return this.execution.getTimes();
	}

	public void up(){
		setChanged();
		notifyObservers();
	}
	
}
